local R = require "routes"
local A = require "app.core.app"
--
-- Global objects
--
app = A

--
-- Helper functions
--
function helper_try_to_load_controller(str)
	str = 'app.' .. str
	local succ, m = pcall(require, str)
	if not succ then
		return succ, 'missing controller: '..str..'\n==>>>\t'..m
	end
	return succ, m
end

function helper_try_to_call_action(web, controller, action, id)

	__response__ = ""
	__app__		 = app
	__web__		 = web
	
	code = '__response__ = '..controller..'.'..action
	code = code .. '(__app__, __web__, '.. '"'..id..'"' .. ')'

	local succ, m = pcall(loadstring(code))
	if not succ then
		return succ, 'missing action: '..controller..':'..action..'\n==>>>\t'..m
	end

	return succ, __response__
end

function helper_format_error_msg(msg)
	return '<h2>500 Internal Server Error</h2><pre>' .. msg .. '</pre>'
end

--
-- Main controller
--

function application_router(web)
	local uri = string.gsub(web.uri, "?.*", "")

	local r = R("/app/?:controller?/?:action?/?:id?")
	local t = r:match(uri)
	
	t.controller = t.controller or 'home'
	t.action     = t.action     or 'index'
	t.id     	 = t.id			or ''

	if t.controller == "exit" then
		return {code = 1 , cont = "exit"}
	end
	
	local succ, m = helper_try_to_load_controller(t.controller)
	if not succ then
		return {code = 0 , cont = helper_format_error_msg(m)}
	end

	succ, m = helper_try_to_call_action(web, t.controller, t.action, t.id)
	if not succ then
		return {code = 0 , cont = helper_format_error_msg(m)}
	end

	return {code = 0 , cont = m}
end


function dispatch(web)
	local r = application_router(web)
	reply(r.cont)
	return r.code
end
